/*
 * All the function for frequency and amplitude setting for channel 1
 * */
#include <math.h>
#include <myUart.h>
#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include <string.h>
#include "inc/hw_memmap.h"
#include "inc/hw_gpio.h"
#include "inc/hw_nvic.h"
#include "inc/hw_sysctl.h"
#include "inc/hw_types.h"
#include "driverlib/fpu.h"
#include "driverlib/gpio.h"
#include "driverlib/flash.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/uart.h"
#include "driverlib/udma.h"
#include "driverlib/rom.h"
#include "grlib/grlib.h"
#include "grlib/widget.h"
#include "grlib/canvas.h"
#include "grlib/checkbox.h"
#include "grlib/container.h"
#include "grlib/pushbutton.h"
#include "grlib/radiobutton.h"
#include "grlib/slider.h"

#include "lcd_tools/Kentec320x240x16_ssd2119_spi.h"
#include "lcd_tools/touch.h"

#include "FreqAmpSelch1.h"
#include "InitializeFunctions.h"

//frequency and amplitude variable for channel 1
float freq = 2;
float amp = 1;
char ampStr[15], freqStr[15];

//All the button description for frequency - 1 setting
RectangularButton(freqCoarseIncButCh1, 0, 0, 0, &g_sKentec320x240x16_SSD2119,
                  160, 24, 65, 37, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0,
                  0, BUT_TEXT_COLOR, &g_sFontCm20, " + ", 0, 0, 0, 0,
                  freqCoarseIncButCh1Fun);
RectangularButton(freqCoarseDecButCh1, 0, 0, 0, &g_sKentec320x240x16_SSD2119,
                  240, 24, 65, 37, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0,
                  0, BUT_TEXT_COLOR, &g_sFontCm20, " - ", 0, 0, 0, 0,
                  freqCoarseDecButCh1Fun);
RectangularButton(freqFineIncButCh1, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 160,
                  66, 65, 37, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0, 0,
                  BUT_TEXT_COLOR, &g_sFontCm20, " + ", 0, 0, 0, 0,
                  freqFineIncButCh1Fun);
RectangularButton(freqFineDecButCh1, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 240,
                  66, 65, 37, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0, 0,
                  BUT_TEXT_COLOR, &g_sFontCm20, " - ", 0, 0, 0, 0,
                  freqFineDecButCh1Fun);

//All the button description for amplitude - 1 setting
RectangularButton(ampCoarseIncButCh1, 0, 0, 0, &g_sKentec320x240x16_SSD2119,
                  160, 108, 65, 37, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL,
                  0, 0, BUT_TEXT_COLOR, &g_sFontCm20, " + ", 0, 0, 0, 0,
                  ampCoarseIncButCh1Fun);
RectangularButton(ampCoarseDecButCh1, 0, 0, 0, &g_sKentec320x240x16_SSD2119,
                  240, 108, 65, 37, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL,
                  0, 0, BUT_TEXT_COLOR, &g_sFontCm20, " - ", 0, 0, 0, 0,
                  ampCoarseDecButCh1Fun);
RectangularButton(ampFineIncButCh1, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 160,
                  150, 65, 37, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0, 0,
                  BUT_TEXT_COLOR, &g_sFontCm20, " + ", 0, 0, 0, 0,
                  ampFineIncButCh1Fun);
RectangularButton(ampFineDecButCh1, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 240,
                  150, 65, 37, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0, 0,
                  BUT_TEXT_COLOR, &g_sFontCm20, " - ", 0, 0, 0, 0,
                  ampFineDecButCh1Fun);

//back and forth functionality buttons
RectangularButton(backButFAS, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 0, 195, 90,
                  44, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, BUT_PRESS, 0,
                  BUT_TEXT_COLOR, &g_sFontCm20, "BACK", 0, 0, 0, 0,
                  backButFASFunc);
RectangularButton(nextButFAS, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 230, 195,
                  90, 44, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, BUT_PRESS,
                  0, BUT_TEXT_COLOR, &g_sFontCm20, "NEXT", 0, 0, 0, 0,
                  nextButFASFunc);
// update function for frequncy both on screen and UART
void updateFreq()
{

    printFreqStr(freqStr, &freq);
    //putInt(freq);
    makeRect(&freqRect, 10, 49, 79, 79, RECT_FREQAMP_COLOR, freqStr);
}

// update function for amplitude both on screen and UART
void updateAmp()
{
    printAmpStr(ampStr, &amp);
    //putFloat(amp,1);
    makeRect(&ampRect, 10, 149, 79, 179, RECT_FREQAMP_COLOR, ampStr);
}

// onclik functions for frequency change
void freqCoarseIncButCh1Fun(tWidget *psWidget)
{
    freq = freq + 5;
    updateFreq();
}

void freqCoarseDecButCh1Fun(tWidget *psWidget)
{
    freq = freq - 5;
    if (freq <= 0)
    {
        freq = 1;
    }
    updateFreq();
}

void freqFineIncButCh1Fun(tWidget *psWidget)
{
    freq = freq + 1;
    updateFreq();
}

void freqFineDecButCh1Fun(tWidget *psWidget)
{
    freq = freq - 1;
    if (freq <= 0)
    {
        freq = 1;
    }
    updateFreq();
}

// onclik functions for amplitude change
void ampCoarseIncButCh1Fun(tWidget *psWidget)
{
    amp = amp + 1;
    updateAmp();
}

void ampCoarseDecButCh1Fun(tWidget *psWidget)
{
    amp--;
    if (amp <= 0)
    {
        amp = 1;
    }
    updateAmp();
}

void ampFineIncButCh1Fun(tWidget *psWidget)
{
    amp = amp + 0.1;
    updateAmp();
}

void ampFineDecButCh1Fun(tWidget *psWidget)
{
    amp = amp - 0.1;
    if (amp <= 0)
    {
        amp = 1;
    }
    updateAmp();
}

//onclick function for the Back button on freq&amp select - 1 screen
void backButFASFunc(tWidget *psWidget)
{

    WidgetRemove((tWidget*) &freqCoarseIncButCh1);
    WidgetRemove((tWidget*) &freqCoarseDecButCh1);
    WidgetRemove((tWidget*) &freqFineIncButCh1);
    WidgetRemove((tWidget*) &freqFineDecButCh1);

    WidgetRemove((tWidget*) &ampCoarseIncButCh1);
    WidgetRemove((tWidget*) &ampCoarseDecButCh1);
    WidgetRemove((tWidget*) &ampFineIncButCh1);
    WidgetRemove((tWidget*) &ampFineDecButCh1);

    WidgetRemove((tWidget*) &backButFAS);
    WidgetRemove((tWidget*) &nextButFAS);

    clr_scrn_total();

    homeScreen();
}

//onclick function for the next button on freq&amp select - 1 screen
void nextButFASFunc(tWidget *psWidget)
{
    WidgetRemove((tWidget*) &freqCoarseIncButCh1);
    WidgetRemove((tWidget*) &freqCoarseDecButCh1);
    WidgetRemove((tWidget*) &freqFineIncButCh1);
    WidgetRemove((tWidget*) &freqFineDecButCh1);

    WidgetRemove((tWidget*) &ampCoarseIncButCh1);
    WidgetRemove((tWidget*) &ampCoarseDecButCh1);
    WidgetRemove((tWidget*) &ampFineIncButCh1);
    WidgetRemove((tWidget*) &ampFineDecButCh1);

    WidgetRemove((tWidget*) &backButFAS);
    WidgetRemove((tWidget*) &nextButFAS);

    clr_scrn_total();

    freqAmpSelScreenCh2();
}

//onclick function for the next button on home screen (adding widgets to the screen)
void freqAmpSelScreenCh1()
{
    screenChar = 'b';

    clr_scrn_total();

    // for Freq
    WidgetAdd(WIDGET_ROOT, (tWidget*) &freqCoarseIncButCh1);
    WidgetPaint((tWidget* )&freqCoarseIncButCh1);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &freqCoarseDecButCh1);
    WidgetPaint((tWidget* )&freqCoarseDecButCh1);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &freqFineIncButCh1);
    WidgetPaint((tWidget* )&freqFineIncButCh1);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &freqFineDecButCh1);
    WidgetPaint((tWidget* )&freqFineDecButCh1);

    // for Amp

    WidgetAdd(WIDGET_ROOT, (tWidget*) &ampCoarseIncButCh1);
    WidgetPaint((tWidget* )&ampCoarseIncButCh1);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &ampCoarseDecButCh1);
    WidgetPaint((tWidget* )&ampCoarseDecButCh1);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &ampFineIncButCh1);
    WidgetPaint((tWidget* )&ampFineIncButCh1);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &ampFineDecButCh1);
    WidgetPaint((tWidget* )&ampFineDecButCh1);

    // for last line

    WidgetAdd(WIDGET_ROOT, (tWidget*) &backButFAS);
    WidgetPaint((tWidget* )&backButFAS);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &nextButFAS);
    WidgetPaint((tWidget* )&nextButFAS);

    makeRect(&FuncGenRect, 0, 0, 319, 19, RECT_FOREGROUND_COLOR,
             "FUNCTION GENERATOR");
    // add the calculation of freq
    updateFreq();
    makeRect(&freqCoarseRect, 90, 39, 150, 59, RECT_FOREGROUND_COLOR, "Coarse");
    makeRect(&freqFineRect, 90, 79, 150, 99, RECT_FOREGROUND_COLOR, "Fine");
    //add the calcualtion for Amp
    updateAmp();
    makeRect(&ampCoarseRect, 90, 129, 150, 149, RECT_FOREGROUND_COLOR,
             "Coarse");
    makeRect(&ampFineRect, 90, 169, 150, 189, RECT_FOREGROUND_COLOR, "Fine");
    makeRect(&freqAmpRect, 90, 194, 229, 239, RECT_FOREGROUND_COLOR,
             "Freq & Amp Sel Ch1");
}
